function stk_exp_window(varargin)
%This function allows you to use the keyboard to step through a stack in a
%window.
%Syntax: stk_exp_windows('Stack',stk,'figure',figure_pointr);
%Input: stack = the stack of images
%       figure = the frame pointer
%Output: none

%Make the variables global so the subfunctions can grab them
%global STK FIG_PTR INDEX IMG_NUM
global PAUSE
warning off all

%catch subfunction calls
if size(varargin,2)==1 && ischar(varargin{1})
    feval(varargin{:});
    return;
else
    %parse the input
    [stk,fig_ptr,index,img_num] = parse(varargin);
    %create a structure of the data so that we can access form the figure
    %itself
    userdata.stk = stk;
    userdata.figure = fig_ptr;
    userdata.index = index;
    userdata.image_num = img_num;
    PAUSE = 0;
end

%setup callback functions & store figure info
set(fig_ptr, 'WindowButtonDownFcn', 'stk_exp_window(''buttondown'');', ...
        'KeyPressFcn', 'stk_exp_window(''keypress'');',...
        'UserData',userdata);

%Display the first image
figure(fig_ptr)
image(stk(:,:,index));
colormap(gray(256));
axis off;
set(gca,'position',[0 0 1 1]);
text(10,10,['frame #: ',num2str(index)],'Color',[1 1 1]);

%--------------------------------------------------------------------------
%Subfunction to parse the input
function [stk,fig_ptr,index,img_num] = parse(input)
%Initiate Parameter Space
index = 1;
fig_ptr = [];

%Parse the input
if ~isempty(input)
    a = size(input,2);
    for i = 1:2:a
        if ischar(input{1,i})
            switch input{1,i}
                case 'stack'
                    stk = input{1,i+1};
                    img_num = size(stk,3);
                case 'figure'
                    fig_ptr = input{1,i+1};
                otherwise
                    error(['Error: ',input{1,i},' is not a valid input to stk_exp_window.']);
            end
        else
            error(['Error: You have entered an improper argument. Please check Help for how to use stk_exp_window.']);
        end
    end
end

if isempty(fig_ptr)
    %center the figure window
    rez = get(0,'screensize');
    x_size = size(stk,2);
    y_size = size(stk,1);
    x = (rez(3)-x_size)/2;
    y = (rez(4)-y_size)/2;
    fig_ptr = figure('units','pixels','position',[x y x_size y_size],'menubar','none','toolbar','none','name','Stack Explore');
end

%-------------------------------------------------------------------------
%Subfunction for key response
function keypress 

userdata = get(gcf,'UserData');
fig_ptr = userdata.figure;
index = userdata.index;
img_num = userdata.image_num;
stk = userdata.stk;

key = get(fig_ptr, 'CurrentCharacter');
switch key
    case {char(46)}  %left key move every 10 frames
        figure(fig_ptr)
        for i = index:index+20
            index = i;
            if index>img_num
                index = i-img_num;
            end
            image(stk(:,:,index));
            colormap(gray(256));
            axis off;
            set(gca,'position',[0 0 1 1]);
            text(10,10,['frame #: ',num2str(index)],'Color',[1 1 1]);
            figure(fig_ptr)
            waitsecs(0.05);
        end
        userdata.index = index;
        set(gcf,'UserData',userdata);
    case {char(44)} %right key
        figure(fig_ptr)
        for i = index:-1:index-20
            index = i;
            if index<1
                index = img_num+i;
            end
            image(stk(:,:,index));
            colormap(gray(256));
            axis off;
            set(gca,'position',[0 0 1 1]);
            text(10,10,['frame #: ',num2str(index)],'Color',[1 1 1]);
            figure(fig_ptr)
            waitsecs(0.05);
        end
        userdata.index = index;
        set(gcf,'UserData',userdata);
    case {char(13), char(3)}   % enter and return keys
    delete(fig_ptr);
    clear global PAUSE PLAY LOCATION
end

%-------------------------------------------------------------------------
% Subfunction buttondown
function buttondown 

global PAUSE PLAY LOCATION

userdata = get(gcf,'UserData');
fig_ptr = userdata.figure;
index = userdata.index;
img_num = userdata.image_num;
stk = userdata.stk;

mouse_action = get(fig_ptr, 'SelectionType');
switch mouse_action
    case 'open'
        % stop
        delete(fig_ptr);
        clear global PAUSE PLAY LOCATION
    case 'normal'
        PLAY = 1;
        if PAUSE == 1
            index = LOCATION;
            PAUSE = 0;
        end
        %left click
        figure(fig_ptr)
        for i = index:img_num
            if PLAY
                image(stk(:,:,i));
                colormap(gray(256));
                axis off;
                set(gca,'position',[0 0 1 1]);
                text(10,10,['frame #: ',num2str(i)],'Color',[1 1 1]);
                figure(fig_ptr)
                waitsecs(0.05);
                LOCATION = i;
            end
        end
    case 'alt'
        %right click
        PLAY = 0;
        PAUSE = 1;
%         figure(fig_ptr)
%         for i = img_num:-1:1
%             image(stk(:,:,i));
%             colormap(gray(256));
%             axis off;
%             set(gca,'position',[0 0 1 1]);
%             text(10,10,['frame #: ',num2str(i)],'Color',[1 1 1]);
%             figure(fig_ptr)
%             waitsecs(0.05);
%         end
end